import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PecinskiZecovi {
    static int n;
    static List<Integer>[] graph;
    static int[] strength;
    static int[] platformChange;
    static int[] jumpChange;
    static int[] jumps;

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        // Ucitavanje broja soba i zeca
        n = Integer.parseInt(br.readLine());

        // Inicijalizacija grafa
        graph = new ArrayList[n + 1];
        for (int i = 1; i <= n; i++) {
            graph[i] = new ArrayList<>();
        }

        // Ucitavanje povezanosti soba
        for (int i = 1; i < n; i++) {
            StringTokenizer st = new StringTokenizer(br.readLine());
            int u = Integer.parseInt(st.nextToken());
            int v = Integer.parseInt(st.nextToken());
            graph[u].add(v);
            graph[v].add(u);
        }

        // Ucitavanje prisustva platformi za skakanje
        platformChange = new int[n + 1];
        StringTokenizer platformSt = new StringTokenizer(br.readLine());
        for (int i = 1; i <= n; i++) {
            platformChange[i] = Integer.parseInt(platformSt.nextToken());
        }

        // Ucitavanje promena pre skoka za svakog zeca
        jumpChange = new int[n + 1];
        StringTokenizer jumpSt = new StringTokenizer(br.readLine());
        for (int i = 1; i <= n; i++) {
            jumpChange[i] = Integer.parseInt(jumpSt.nextToken());
        }

        // Inicijalizacija niza za cuvanje broja skokova
        jumps = new int[n + 1];

        // Poziv DFS za svakog zeca
        dfs(1, 0);

        // Ispisivanje rezultata
        for (int i = 1; i <= n; i++) {
            System.out.print(jumps[i] + " ");
        }
    }

    // DFS funkcija koja racuna broj skokova za zeca u odredenoj sobi
    private static void dfs(int node, int parent) {
        // Racunanje broja skokova za trenutnog zeca
        if (parent == 0) {
            jumps[node] = 1;
        } else {
            jumps[node] = Math.max(1, jumps[parent] - jumpChange[parent]);
        }

        // Prolazak kroz susedne sobe
        for (int neighbor : graph[node]) {
            if (neighbor != parent) {
                dfs(neighbor, node);
            }
        }

        // Ako postoji platforma za skakanje u trenutnoj sobi, a zec nije mogao izici iz pcele,
        // promeni se stanje sobe i ponovno izracunava broj skokova
        if (platformChange[node] == 1 && jumps[node] <= 0) {
            platformChange[node] = 0; // Brisanje platforme
            dfs(node, parent);
        }
    }
}